(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     71478,       2063]*)
(*NotebookOutlinePosition[     72907,       2104]*)
(*  CellTagsIndexPosition[     72863,       2100]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Integraci\[OAcute]n de funciones de varias variables", "Title"],

Cell[TextData[StyleBox[
"Departamento de An\[AAcute]lisis Matem\[AAcute]tico\nUniversidad de Granada\n\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez",
  FontSize->12]], "Author",
  TextAlignment->Left],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell["\<\
En este cuaderno debes aprender las siguientes cosas.
Usar los comandos Integrate[ ] y NIntegrate[ ] para calcular integrales de \
funciones de varias variables.
Calcular integrales dobles en coordenadas polares y triples en coordenadas \
esf\[EAcute]ricas.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section"],

Cell[BoxData[
    \(<< Graphics`Master`\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(Off[General::spell1]; 
    \)\n (*para\ que\ Mathematica\ no\ nos\ moleste\ con\ avisos\ de\ error\ 
        en\ los\ nombres\ de\ los\ comandos*) \)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{
      RowBox[{"(*", 
        RowBox[{
          StyleBox[
            RowBox[{"This", 
              StyleBox["Mathematica",
                FontSlant->"Italic"]}]], 
          StyleBox[" ",
            FontSlant->"Italic"], "code", " ", "was", " ", "developed", " ", 
          "by", " ", "Major", " ", "Glenn", " ", "Sjoden", " ", "at", " ", 
          "the", " ", "US", " ", "Air", " ", "Force", " ", 
          "\[IndentingNewLine]", \(Academy'\), "s", " ", "Department", " ", 
          "of", " ", 
          StyleBox[\(Mathematica l\),
            FontSlant->"Italic"], " ", 
          StyleBox["Sciences",
            FontSlant->"Italic"], " ", "and", " ", "later", " ", "adapted", 
          " ", "to", " ", \(it'\), "s", " ", "current", " ", "format", " ", 
          "by", " ", "Lt", " ", "Col", " ", "Steve", " ", "Hadfield"}], 
        "*)"}], "\[IndentingNewLine]", 
      \(Riemann2D[f_, xvars_, yvars_, \ nn_, mm_, \ opts___] := 
        CompoundExpression[
          \[IndentingNewLine]cell[xo_, yo_, zo_, x1_, y1_, z1_, colr_] := 
            \[IndentingNewLine]Graphics3D[
              Table[{FaceForm[colr], 
                  \[IndentingNewLine]Cuboid[{xo, yo, zo}, {x1, y1, z1}]}, {i, 
                  0, 1, 2}, {j, 1, 1, 2}, {k, 1, 1, 2}]], \n\t
          cellw[xo_, yo_, zo_, x1_, y1_, z1_, colr_] := 
            \[IndentingNewLine]WireFrame[
              Graphics3D[
                Table[{colr, Cuboid[{xo, yo, zo}, {x1, y1, z1}]}, 
                  \[IndentingNewLine]{i, 0, 1, 2}, {j, 1, 1, 2}, {k, 1, 1, 
                    2}]]], \[IndentingNewLine]xlo = xvars[\([2]\)], 
          xhi = xvars[\([3]\)], \[IndentingNewLine]ylo = yvars[\([2]\)], 
          yhi = yvars[\([3]\)], 
          \[IndentingNewLine]dex = N[\((xhi - xlo)\)\/nn], 
          dey = N[\((yhi - ylo)\)\/mm], 
          \[IndentingNewLine]p3d = 
            Plot3D[f, xvars, yvars, 
              \[IndentingNewLine]BoxRatios \[Rule] {1, 1, 1.5}, 
              AxesLabel \[Rule] {x, y, z}, DisplayFunction \[Rule] Identity], 
          \[IndentingNewLine]RVol = 0, 
          \[IndentingNewLine]b3d = 
            Table[{xb = xa + dex; yb = ya + dey; 
                \[IndentingNewLine]xavg = \(xa + xb\)\/2; 
                yavg = \(ya + yb\)\/2; 
                \[IndentingNewLine]zb = 
                  f /. {xvars[\([1]\)] -> xavg, yvars[\([1]\)] -> yavg}; 
                RVol = RVol + \((xb - xa)\) \((yb - ya)\)*zb; 
                \[IndentingNewLine]cell[xa, ya, 0, xb, yb, zb, Blue]}, 
              \[IndentingNewLine]{xa, xlo, xhi - dex, dex}, {ya, ylo, 
                yhi - dey, dey}], \ 
          Show[{p3d, b3d}, \ opts, 
            PlotLabel \[Rule] 
              StyleForm[
                "\<Vol\[TildeFullEqual]\>"\ TraditionalForm[\ RVol // N], 
                FontSize \[Rule] 12]]]; \)}]], "Input",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{
      RowBox[{"fig1", ":=", 
        RowBox[{"Module", "[", 
          RowBox[{\({f}\), ",", 
            RowBox[{
            \(f[x_, y_] = \@\(36 - 3  x\^2 - 6  y\^2\)\), ";", 
              "\[IndentingNewLine]", 
              RowBox[{"G1", "=", 
                RowBox[{"Plot3D", "[", 
                  RowBox[{
                  \(If[\(-2\) \[LessEqual] x \[LessEqual] 2\  && \ 
                        \(-2\) \[LessEqual] y \[LessEqual] 2, f[x, y], 0]\), 
                    ",", \({x, \ \(-2.5\), \ 2.5}\), ",", " ", 
                    \({y, \ \(-2.5\), 2.5}\), ",", 
                    \(BoxRatios \[Rule] {1, 1, 1.5}\), ",", 
                    StyleBox[\(BoxStyle\  -> \ RGBColor[1, 0, 0]\),
                      FormatType->StandardForm], 
                    StyleBox[",",
                      FormatType->StandardForm], 
                    \(Background \[Rule] RGBColor[1, 1, 0.75]\), ",", 
                    \(AxesEdge 
                      \[Rule] {{\(-1\), \(-1\)}, {1, \(-1\)}, {\(-1\), 
                          \(-1\)}}\), ",", 
                    \(Ticks 
                      \[Rule] {{{\(-2\), "\<-2\>"}, {0, "\<0\>"}, {2, 
                            "\<2\>"}}, {{2, "\<2\>"}, {0, "\<0\>"}}, {{2, 
                            "\<2\>"}, {4, "\<4\>"}, {6, "\<6\>"}}}\), ",", 
                    \(PlotRange 
                      \[Rule] {{\(-2.5\), 2.5}, {\(-2.5\), 2.5}, {0, 6}}\), 
                    ",", \(AxesLabel \[Rule] {"\<X\>", "\<Y\>", "\<Z\>"}\), 
                    ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], 
              ";", 
              RowBox[{"G2", "=", 
                RowBox[{"ParametricPlot3D", "[", 
                  RowBox[{
                  \({0, y, t*f[0, y]}\), ",", " ", \({y, \ \(-2\), 2}\), ",", 
                    \({t, 0, 1}\), ",", \(BoxRatios \[Rule] {1, 1, 1.5}\), 
                    ",", 
                    StyleBox[\(BoxStyle\  -> \ RGBColor[1, 0, 0]\),
                      FormatType->StandardForm], 
                    StyleBox[",",
                      FormatType->StandardForm], 
                    \(Background \[Rule] RGBColor[1, 1, 0.75]\), ",", 
                    \(AxesEdge 
                      \[Rule] {{\(-1\), \(-1\)}, {1, \(-1\)}, {\(-1\), 
                          \(-1\)}}\), ",", 
                    \(Ticks -> {{{0, "\<X=0\>"}}, {{0, "\<Y=0\>"}, {2, 
                            "\<2\>"}, {\(-2\), "\<-2\>"}}, {{2, "\<2\>"}, {4, 
                            "\<4\>"}, {6, "\<6\>"}}}\), ",", 
                    \(PlotRange 
                      \[Rule] {{\(-2.5\), 2.5}, {\(-2.5\), 2.5}, {0, 6}}\), 
                    ",", \(DisplayFunction \[Rule] Identity\)}], "]"}]}], 
              ";", "\[IndentingNewLine]", 
              RowBox[{"G3", "=", 
                RowBox[{"FilledPlot", "[", 
                  RowBox[{
                  \(f[0, y]\), ",", \({y, \(-2\), 2}\), ",", 
                    \(PlotRange \[Rule] {{\(-3\), 3}, {0, 6.5}}\), ",", 
                    \(AspectRatio \[Rule] Automatic\), ",", 
                    \(Fills \[Rule] RGBColor[0, 1, 1]\), ",", 
                    \(DisplayFunction \[Rule] Identity\), ",", 
                    \(Background \[Rule] RGBColor[1, 1, 0.75]\), ",", 
                    \(AxesLabel \[Rule] {"\<y\>", "\<z=f(0,y)\>"}\), ",", 
                    StyleBox[\(AxesStyle\  -> \ RGBColor[1, 0, 0]\),
                      FormatType->StandardForm], 
                    StyleBox[",",
                      FormatType->StandardForm], 
                    \(Ticks 
                      \[Rule] {{{\(-2\), "\<-2\>",  .01}, {0, 
                            "\<0\>",  .01}, {2, "\<2\>",  .01}}, {{2, 
                            "\<2\>",  .01}, {4, "\<4\>",  .01}, {6, 
                            "\<6\>",  .01}}}\)}], "]"}]}], ";", 
              "\[IndentingNewLine]", 
              \(Show[GraphicsArray[{G1, G2, G3}], 
                ImageSize \[Rule] {528, 220}, 
                ImageMargins \[Rule] {{0, 0}, {0, 0}}, 
                ImageRegion \[Rule] {{0, 1}, {0, 1}}, 
                DisplayFunction \[Rule] $DisplayFunction]\)}]}], "]"}]}], 
      ";"}]], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(polares := 
      Show[Graphics[{Line[{{\(- .3\), 0}, {2, 0}}], 
            Line[{{0, \(- .3\)}, {0, 2}}], Text["\<Y\>", {0.1, 1.9}], 
            Text["\<X\>", {2,  .1}], 
            Circle[{0, 0},  .4, {0, \[Pi]/4}], {Hue[ .6], 
              Text["\<(x,y)\>", {1.1, 1.15}]}, {PointSize[ .035], Hue[ .6], 
              Point[{1, 1}], Hue[0], Point[{0, 1}], Point[{1, 0}], 
              Text["\<\[Rho]cos\[Theta]\>", {1, \(- .15\)}], 
              Text["\<\[Rho]sen\[Theta]\>", { .33, 1.15}], 
              Text["\<\[Theta]\>", { .5,  .2}]}, {Line[{{0, 0}, {1, 1}}], 
              Dashing[{ .02,  .02}], Line[{{0, 1}, {1, 1}, {1, 0}}]}}], 
        Background \[Rule] RGBColor[1, 1, 0.75], 
        AspectRatio \[Rule] Automatic, 
        TextStyle \[Rule] {FontSize \[Rule] 12, FontWeight -> "\<Bold\>"}, 
        ImageSize \[Rule] {390, 162}]; \)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(esfericas := 
      Show[Graphics[{
            Line[{{0, 6}, {0, 0}, {2, 4}, {0, 0}, {6, 0}, {0, 0}, {\(-4\), 
                  \(-4\)}}], {Dashing[{ .012,  .012}], 
              Line[{{0, 5.5}, {2, 4}, {2, \(-1.5\)}, {0, 0}}]}, {
              Dashing[{ .012,  .012}], Line[{{2, \(-1.5\)}, {3.5, 0}}]}, {
              Dashing[{ .012,  .012}], 
              Line[{{2, \(-1.5\)}, {\(-1.5\), \(-1.5\)}}]}, 
            Circle[{0, 0}, 2, {ArcTan[2], \[Pi]/2}], 
            Circle[{0, 0},  .6, {\(-3\) \[Pi]/4, ArcTan[\(- .75\)]}], {
              Hue[0], PointSize[ .02], \ Point[{0.01, 5.5}], 
              Text["\<\[Rho]cos\[CurlyPhi]\>", {1, 5.6}], 
              Text["\<\[Rho]\>", {1.3, 2.12}], 
              Text["\<\[Rho]sen\[CurlyPhi]\>", {2.2, \(-1.8\)}], 
              Text["\<\[Rho]sen\[CurlyPhi]cos\[Theta]\>", {\(-1.7\), 
                  \(-1.8\)}], 
              Text["\<\[Rho]sen\[CurlyPhi]sen\[Theta]\>", {3.7,  .35}], 
              Text["\<\[CurlyPhi]\>", { .485, 2.47}], 
              Text["\<\[Theta]\>", {0, \(-1\)}]}, {Hue[0], PointSize[ .02], \ 
              Point[{3.5, 0}]}, {Hue[0], PointSize[ .02], \ 
              Point[{\(-1.5\), \(-1.5\)}]}, {Hue[0.6], PointSize[ .02], \ 
              Point[{2, 4}], Text["\<(x,y,z)\>", {2.8, 4.4}]}, 
            Text["\<X\>", {\(-3.4\), \(-3.9\)}], Text["\<Z\>", {0.3, 5.95}], 
            Text["\<Y\>", {5.95, 0.25}]}], AspectRatio \[Rule] Automatic, 
        Background \[Rule] RGBColor[1, 1, 0.75], 
        TextStyle \[Rule] {FontSize \[Rule] 14, FontWeight -> "\<Bold\>"}]; 
    \)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Integraci\[OAcute]n de funciones de dos y tres variables", "Section"],

Cell[TextData[{
  "Para tener una idea intuitiva de lo que se hace cuando se calcula una \
integral doble, consideremos una funci\[OAcute]n (todas las funciones se \
suponen continuas) positiva de dos variables ",
  Cell[BoxData[
      \(TraditionalForm\`f : A\[LongRightArrow]\[DoubleStruckCapitalR]\)]],
  " , ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) \[GreaterEqual] 0\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\) \[Element] A\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^2\)]],
  ". En tal caso, la integral doble de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " es el volumen del \"cilindro\" en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " cuya base es el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " y que tiene como \"tapadera\" la gr\[AAcute]fica de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". "
}], "Text"],

Cell[TextData[{
  " ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\(\[Integral]\_A\( f(x, y)\) \(d(x, y)\)\) = 
        volumen\ {\((x, y, z)\) : \ \((x, y)\) \[Element] \ A, \ 
            0 \[LessEqual] z \[LessEqual] \ f(x, y)}\)],
    FontWeight->"Bold"]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Para calcular el volumen del conjunto ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\ {\((x, y, z)\) : \ \((x, y)\) \[Element] \ A, \ 
        0 \[LessEqual] z \[LessEqual] \ f(x, y)}\)\)]],
  " lo que se hace es obtener aproximaciones y pasar al l\[IAcute]mite. \
Consideremos el caso en que",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[\(\ A = \ \([a, b]\)\[Times]\([c, d]\)\),
            "TraditionalForm"], " "}], TraditionalForm]]],
  " y sean ",
  Cell[BoxData[
      \(TraditionalForm
      \`a = \(\(x\_0 < x\_1 < x\_2 < \  ... \)\  < x\_\(n - 1\) < x\_n = b
          \)\)]],
  " y  ",
  Cell[BoxData[
      \(TraditionalForm
      \`c = \(\(y\_0 < y\_1 < y\_2 < \  ... \)\  < y\_\(m - 1\) < y\_m = d
          \)\)]],
  " particiones de los intervalos ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)]],
  " y  ",
  Cell[BoxData[
      \(TraditionalForm\`\([c, d]\)\)]],
  " respectivamente.  Elijamos puntos ",
  Cell[BoxData[
      \(TraditionalForm
      \`\((s\_k\ , t\_j)\) \[Element] 
        \([x\_\(k - 1\), x\_k]\)\[Times]\([y\_\(j - 1\), y\_j]\)\)]],
  ", y formemos el ortoedro cuya base es el rect\[AAcute]ngulo ",
  Cell[BoxData[
      \(TraditionalForm
      \`\([x\_\(k - 1\), x\_k]\)\[Times]\([y\_\(j - 1\), y\_j]\)\)]],
  " y altura igual a ",
  Cell[BoxData[
      \(TraditionalForm\`f(s\_k, t\_j)\)]],
  ". El volumen de dicho ortoedro es ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(f(s\_k, t\_j)\),
            "TraditionalForm"], \((x\_k - x\_\(k - 1\))\), 
          \((y\_j - y\_\(j - 1\))\)}], TraditionalForm]]],
  ". La suma "
}], "Text"],

Cell[BoxData[
    FormBox[
      StyleBox[
        RowBox[{\(\[Sum]\+\(k = 1\)\%n\), 
          RowBox[{\(\[Sum]\+\(j = 1\)\%m\), 
            RowBox[{
              FormBox[\(f(s\_k, t\_j)\),
                "TraditionalForm"], \((x\_k - x\_\(k - 1\))\), 
              \((y\_j - y\_\(j - 1\))\)}]}]}],
        FontWeight->"Bold"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  " se llama",
  StyleBox[" ",
    FontWeight->"Bold"],
  "una",
  StyleBox[" suma de Riemann",
    FontWeight->"Bold"],
  " de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " y su valor es una aproximaci\[OAcute]n al volumen buscado. La integral  \
de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en el rect\[AAcute]ngulo ",
  Cell[BoxData[
      \(TraditionalForm\`A = \([a, b]\)\[Times]\([c, d]\)\)]],
  " se define como el l\[IAcute]mite de las sumas de Riemann cuando las \
longitudes de los intervalos de las particiones tienden a cero."
}], "Text"],

Cell[TextData[{
  "Consideremos la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = 1 + x\^2 + y\^2\)]],
  ". Como ya sabes, el comando \"Plot3D[ ]\" permite representar la gr\
\[AAcute]fica de dicha funci\[OAcute]n sobre un rect\[AAcute]ngulo."
}], "Text"],

Cell[BoxData[
    \(f[x_, y_] = 1 + x^2 + y^2; \n
    Plot3D[f[x, y], {x, 0, 1}, {y, 0, 1}, 
      Background \[Rule] RGBColor[1, 1, 0.75], 
      PlotRange \[Rule] {{\(- .2\), 1.2}, {\(- .2\), 1.2}, Automatic}, 
      AspectRatio \[Rule] 1, BoxRatios \[Rule] {1, 1, 1}, 
      PlotPoints \[Rule] 30]; \)], "Input"],

Cell[TextData[{
  "Vamos a calcular la integral de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " sobre el cuadrado unidad [01]x[0,1]. Tenemos que calcular el volumen del \
cilindro en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " cuya base es dicho cuadrado y cuya tapadera es la gr\[AAcute]fica de la \
funci\[OAcute]n. Para verlo mejor representamos la funci\[OAcute]n \
siguiente."
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`If[
      0 \[LessEqual] x \[LessEqual] 1\  && 0 \[LessEqual] y \[LessEqual] 1, 
      1 + x\^2 + y\^2, 0]\)], "Text",
  TextAlignment->Center],

Cell[BoxData[
    \(\(Plot3D[\ 
      If[0 \[LessEqual] x \[LessEqual] 1 && 0 \[LessEqual] y \[LessEqual] 1, 
        1 + x^2 + y^2, 0], \ {x, \(- .2\), 1.2}, \ {y, \(- .2\), \ \ 1.2}, 
      Background \[Rule] RGBColor[1, 1, 0.75], AspectRatio \[Rule] 1, 
      BoxRatios \[Rule] {1, 1, 1}, PlotPoints \[Rule] 60]; \)\)], "Input"],

Cell["\<\
De forma an\[AAcute]loga a como se hace para funciones de una variable, \
consideramos particiones en cada uno de los intervalos [0,1]  lo que nos \
proporciona una cuadr\[IAcute]cula que divide el cuadrado [0,1]x[0,1] en \
peque\[NTilde]os rect\[AAcute]ngulos. Aqu\[IAcute] puedes ver la cuadr\
\[IAcute]cula correspondiente a dividir en 10 partes de igual longitud cada \
intervalo. En cada uno de los cuadraditos de la cuadr\[IAcute]cula se ha \
representado su centro.\
\>", "Text"],

Cell[BoxData[
    \(\(Module[{
        averg1 = 
          \((Drop[Range[0, 1,  .1], 1] + Drop[Range[0, 1,  .1], \(-1\)])\)/
            2}, \[IndentingNewLine]CartesianMap[Identity, 
        \ {0, 1, 0.1}, {0, 1, 0.1}, 
        \[IndentingNewLine]Ticks 
          \[Rule] {Range[0, 1,  .1], Range[0, 1,  .1]}, 
        AxesLabel \[Rule] {"\<x\>", "\<y\>"}, PlotStyle \[Rule] {Blue, Red}, 
        Epilog \[Rule] {PointSize[0.015], Hue[1], 
            Flatten[Outer[Point, averg1, averg1] /. 
                Point[x_, y_] \[Rule] Point[{x, y}]]}]]; \)\)], "Input"],

Cell[TextData[{
  "Si multiplicamos el \[AAcute]rea de un cuadradito por el valor de la funci\
\[OAcute]n en su centro, obtenemos el volumen de un ortoedro cuya base es el \
cuadradito y cuya altura es el valor de la funci\[OAcute]n en su centro. Si \
ahora sumamos los vol\[UAcute]menes de todos esos ortoedros obtenemos una \
suma de Riemann que es un valor aproximado del volumen exacto del cilindro. \
Aqu\[IAcute] puedes ver representado gr\[AAcute]ficamente este proceso. El \
comando \"Riemann2D[f[x,y], {x,a,b}, {y,c,d}, n, m, Options]\" hace una \
partici\[OAcute]n del rect\[AAcute]ngulo",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[\(\(\ \)\(\([a, b]\)\[Times]\([c, d]\)\)\),
            "TraditionalForm"]}], TraditionalForm]]],
  " en  ",
  Cell[BoxData[
      \(TraditionalForm\`n\[Times]m\)]],
  " subrect\[AAcute]ngulos, calcula el valor de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en el punto medio de cada uno de ellos y representa la gr\[AAcute]fica de \
",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " y la suma de Riemann correspondiente con el valor aproximado del volumen. \
Admite opciones como \"Plot3D\"."
}], "Text"],

Cell[BoxData[
    \(\(Show[
      Riemann2D[1 + x\^2 + y\^2, {x, 0, 1}, {y, 0, 1}, 6, 6, 
        Background \[Rule] RGBColor[1, 1, 0.75], AspectRatio \[Rule] 1, 
        PlotRange \[Rule] {{\(- .2\), 1.2}, {\(- .2\), 1.2}, Automatic}, 
        BoxRatios \[Rule] {1, 1, 1}], 
      DisplayFunction \[Rule] $DisplayFunction]; \)\)], "Input"],

Cell["\<\
Puedes comprobar c\[OAcute]mo la aproximaci\[OAcute]n mejora conforme aumenta \
el n\[UAcute]mero de puntos de divisi\[OAcute]n\
\>", "Text"],

Cell[BoxData[
    \(\(Show[
      GraphicsArray[
        Table[Riemann2D[1 + x\^2 + y\^2, {x, 0, 1}, {y, 0, 1}, i, i, 
            DisplayFunction \[Rule] Identity, Axes \[Rule] False, 
            PlotRange \[Rule] {{\(- .2\), 1.2}, {\(- .2\), 1.2}, Automatic}, 
            Background \[Rule] RGBColor[1, 1, 0.75]], {i, 8, 14, 3}]], 
      DisplayFunction \[Rule] $DisplayFunction, ImageSize \[Rule] {528, 220}, 
      ImageMargins \[Rule] {{0, 0}, {0, 0}}, 
      ImageRegion \[Rule] {{0, 1}, {0, 1}}]; \)\)], "Input"],

Cell["El valor de la integral es", "Text"],

Cell[BoxData[{
    \(Integrate[1 + x^2 + y^2, {x, 0, 1}, {y, 0, 1}]\), 
    \(N[%]\)}], "Input"],

Cell["Como puedes ver la aproximaci\[OAcute]n obtenida no es mala. ", "Text"],

Cell[TextData[{
  "Para integrar una funci\[OAcute]n",
  Cell[BoxData[
      \(TraditionalForm\`\(\ f[x, y]\ \)\)]],
  "sobre un conjunto acotado ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " que no sea un rect\[AAcute]ngulo, lo que se hace es encerrar el conjunto \
en un rect\[AAcute]ngulo ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \([a, b]\) x[c, d]\)]],
  " e integrar en dicho rect\[AAcute]ngulo la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(g[x, y]\ \)\)]],
  "que coincide con ",
  Cell[BoxData[
      \(TraditionalForm\`f[x, y]\)]],
  "cuando  ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\) \[Element] A\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`g[x, y] = 0\)]],
  "en otro caso. Dicha funci\[OAcute]n puedes definirla en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " en la forma ",
  Cell[BoxData[
      \(TraditionalForm\`g[x, y] = If[cjto[x, y], f[x, y], 0]\)]],
  " donde cjto[x,y] debe ser una funci\[OAcute]n l\[OAcute]gica cuyo valor \
sea True cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\) \[Element] A\)]],
  " y False en otro caso. Con la ayuda de esta misma funci\[OAcute]n puedes \
representar la gr\[AAcute]fica de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " cuando las variables ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " est\[AAcute]n en el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  ". Aqu\[IAcute] puedes ver el cilindro cuya base es el c\[IAcute]rculo de \
centro (1/2,1/2) y radio 1/2 y cuya tapadera es la gr\[AAcute]fica de la func\
\[OAcute]n."
}], "Text"],

Cell[BoxData[{
    \(cjto[x_, y_] := 
      0 \[LessEqual] x \[LessEqual] 1 && 
        1\/2 - \@\(1\/4 - \((x - 1\/2)\)\^2\) \[LessEqual] y \[LessEqual] \ 
          1\/2 + \@\(1\/4 - \((x - 1\/2)\)\^2\)\  (*\ 
      funci\[OAcute]n\ l\[OAcute]gica\ cuyo\ valor\ es\ True\ si\ \((x, y)\)\ 
        est\[AAcute]\ en\ el\ c\[IAcute]rculo\ de\ centro\ \((1\/2, 1\/2)\)\ y
        \ radio\ 1\/2*) \), 
    \(g[x_, y_] := If[cjto[x, y], 1 + x\^2 + y\^2, 0]\), 
    \(\(Plot3D[g[x, y], {x, 0, 1}, {y, 0, 1}, 
      Background \[Rule] RGBColor[1, 1, 0.75], 
      PlotRange \[Rule] {{\(- .2\), 1.2}, {\(- .2\), 1.2}, Automatic}, 
      AspectRatio \[Rule] 1, BoxRatios \[Rule] {1, 1, 1}, 
      PlotRange \[Rule] {0, 3}, PlotPoints \[Rule] 50]; \)\)}], "Input"],

Cell["\<\
Nota: A partir de la versi\[OAcute]n 4 tambi\[EAcute]n puedes usar para esto \
la funci\[OAcute]n \"Boole[ ]\".\
\>", "Text"],

Cell["\<\
Aqu\[IAcute] puedes ver la aproximaci\[OAcute]n de las sumas de Riemann a la \
integral cuando integramos la funci\[OAcute]n en el c\[IAcute]rculo de centro \
(1/2,1/2) y radio 1/2.\
\>", "Text"],

Cell[BoxData[
    \(\(Show[
      Riemann2D[g[x, y], {x, 0, 1}, {y, 0, 1}, 20, 20, 
        Background \[Rule] RGBColor[1, 1, 0.75], AspectRatio \[Rule] 1, 
        PlotRange \[Rule] {{\(- .2\), 1.2}, {\(- .2\), 1.2}, Automatic}, 
        BoxRatios \[Rule] {1, 1, 1}], 
      DisplayFunction \[Rule] $DisplayFunction]; \)\)], "Input"],

Cell["El valor de la integral es", "Text"],

Cell[BoxData[{
    \(Integrate[
      1 + x^2 + y^2, {x, 0, 1}, {y, 1/2 - \@\(1/4 - \((x - 1/2)\)^2\), 
        1/2 + \@\(1/4 - \((x - 1/2)\)^2\)}]\), 
    \(N[%]\), 
    \(Clear["\<@\>"]\)}], "Input"],

Cell[TextData[{
  "La integral de una funci\[OAcute]n de tres variables se define de forma \
parecida. Dicha integral, para el caso de una funci\[OAcute]n positiva ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  definida en un conjunto ",
  StyleBox["A",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  "se interpreta como el \"volumen\" del \"cilindro\" en  ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^4\)]],
  " que tiene como base el conjunto ",
  StyleBox["A",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " y como \"tapadera\" la gr\[AAcute]fica de ",
  StyleBox["f",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\(\[Integral]\(\[Integral]\_A\ \(f(x, y, 
                  z)\) \(d(x, y, z)\)\)\) = 
        volumen\ {\((x, y, z, w)\) : \ \((x, y, z)\) \[Element] A\ , \ 
            0 \[LessEqual] w \[LessEqual] \ f(x, y, z)}\)],
    FontWeight->"Bold"]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Observa que la integral de una funci\[OAcute]n positiva de ",
  StyleBox["una",
    FontSlant->"Italic"],
  " variable mide el \[AAcute]rea de un conjunto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  ", la integral de una funci\[OAcute]n positiva de ",
  StyleBox["dos",
    FontSlant->"Italic"],
  " variables mide el volumen de un conjunto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  "y la integral de una funci\[OAcute]n positiva de ",
  StyleBox["tres",
    FontSlant->"Italic"],
  " variables mide el \"volumen\" de un conjunto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^4\)]],
  ". No obstante, en el caso particular de que integremos la funci\[OAcute]n \
constante igual a 1 en un conjunto ",
  StyleBox["A",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  ", resulta que\n\t\t\t\t\t\t",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(\[Integral]\(\[Integral]\_A\ 
                d(x, y)\)\)\(=\)\(\[AAcute]rea(A)\)\(\ \)\),
          FontWeight->"Bold"], TraditionalForm]]],
  "\nsin m\[AAcute]s que tener en cuenta que el volumen de un cilindro recto \
de altura constante igual a 1 coincide con el \[AAcute]rea de la base. An\
\[AAcute]logamente si integramos la funci\[OAcute]n constante igual a 1 en un \
conjunto ",
  StyleBox["A",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ", resulta que\n\t\t\t\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\(\[Integral]\(\[Integral]\_A\ 
              d(x, y, z)\)\) = volumen\ \((A)\)\)],
    FontWeight->"Bold"]
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "Calcula una suma de Riemann de la funci\[OAcute]n g(x,y)=Cos(1/(xy)) en el \
intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([1/10, 1]\)\[Times]\([1/10, 1]\)\)]],
  " dividido en 40000 rectangulitos iguales. Comprueba la duraci\[OAcute]n \
del c\[AAcute]lculo con el comando Timing[ ] (si tu comando est\[AAcute] bien \
definido, este c\[AAcute]lculo debe hacerse en menos 0.7segundos). Comprueba \
tu resultado usando el comando de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " NIntegrate[ ] para calcular num\[EAcute]ricamente la integral de ",
  Cell[BoxData[
      \(TraditionalForm\`Cos(1/\((x\ y)\))\)]],
  " en el intervalo [1/10,1]\[Times][1/101,1]."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Escribe un comando que calcule sumas de Riemann de una funci\[OAcute]n de \
dos variables. Dicho comando debe ser de la forma \
\"sumariemann2D[f_,{x_,xmin_,xmax_},{y_,ymin_,ymax_},m_,n_]\" donde ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "es una funci\[OAcute]n de dos variables, m es el n\[UAcute]mero de partes \
iguales en que se divide el intervalo [xmin,xmax], n es el n\[UAcute]mero de \
partes iguales en que se divide el intervalo [ymin,ymax]. Dicho comando debe \
calcular el valor de la funci\[OAcute]n en el centro de cada rectangulito en \
que se divide el rect\[AAcute]ngulo [xmin,xmax]x[ymin,ymax],  sumar todos los \
valores as\[IAcute] obtenidos y multiplicar por el \[AAcute]rea de dicho \
rectangulito. Procura que dicho comando trabaje num\[EAcute]ricamente. "
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Teorema de Fubini", "Section"],

Cell[TextData[{
  "El teorema de Fubini permite calcular una integral doble haciendo dos \
integrales simples. No es dif\[IAcute]cil comprender lo que dice el teorema \
ni tampoco lo es entender por qu\[EAcute] se cumple. De hecho, no es la \
primera vez que en este curso aparece dicho teorema, ya lo usamos para \
calcular vol\[UAcute]menes de s\[OAcute]lidos de revoluci\[OAcute]n cuando \
estudiamos las aplicaciones de las Integrales simples.  Un caso particular \
del teorema de Fubini afirma que ",
  StyleBox["el volumen de una regi\[OAcute]n en ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox["\[DoubleStruckCapitalR]", 
          StyleBox["3",
            FontWeight->"Bold"]], TraditionalForm]],
    FontSlant->"Italic"],
  StyleBox["es igual a la integral del \[AAcute]rea de sus secciones por \
planos paralelos a uno dado.",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " Por tanto, el teorema de Fubini permite calcular vol\[UAcute]menes \
calculando \[AAcute]reas de secciones planas. \nConsideremos una funci\
\[OAcute]n positiva, ",
  StyleBox[" f ,",
    FontSlant->"Italic"],
  " definida en el rect\[AAcute]ngulo  ",
  Cell[BoxData[
      \(TraditionalForm\`A = \([a, b]\)\[Times]\([c, d]\)\)]],
  ". Para calcular el volumen del conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[CapitalOmega] = {\((x, y, 
              z)\) : \ \((x, y)\) \[Element] \ A, \ 
          0 \[LessEqual] z \[LessEqual] \ f(x, y)}\)\)\)]],
  " podemos proceder como sigue. Para cada ",
  Cell[BoxData[
      \(TraditionalForm\`x\_0 \[Element] \([a, b]\)\)]],
  " ",
  StyleBox["fijo",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[1, 0, 0]],
  " calculamos el \[AAcute]rea de la secci\[OAcute]n, ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega](x\_0)\)]],
  ",  que se obtiene cortando",
  StyleBox[" \[CapitalOmega]",
    FontWeight->"Bold"],
  "  con el plano de ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`X = x\_0\)]],
  ". F\[IAcute]jate que",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \ \)\(\[CapitalOmega](x\_0)\)\)\)]],
  " es una secci\[OAcute]n de ",
  StyleBox["\[CapitalOmega]",
    FontWeight->"Bold"],
  " perpendicular al eje ",
  StyleBox["OX",
    FontSlant->"Italic"],
  "  y, por tanto, paralela al plano ",
  StyleBox["YZ",
    FontSlant->"Italic"],
  ". Como "
}], "Text"],

Cell[TextData[{
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega](
          x\_0) = \({\((x\_0, y, 
                z)\) : \((x, y, z)\) \[Element] \[CapitalOmega]} = {\((x\_0, 
                y, z)\) : y \[Element] \([c, d]\)\ , \ 
            0 \[LessEqual] z \[LessEqual] f(x\_0, y)}\)\)]]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  " se tiene que",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[\(\[CapitalOmega](x\_0)\),
            "TraditionalForm"]}], TraditionalForm]]],
  " es la regi\[OAcute]n del plano ",
  Cell[BoxData[
      \(TraditionalForm\`X = x\_0\)]],
  " comprendida entre la curva  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"z", 
          StyleBox["=",
            FontSize->16], \(f(x\_0, y)\)}], TraditionalForm]]],
  ", el eje",
  StyleBox[" OY",
    FontSlant->"Italic"],
  " y las rectas ",
  Cell[BoxData[
      \(TraditionalForm\`y = a\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y = b\)]],
  ". Como sabes, el \[AAcute]rea de dicha regi\[OAcute]n viene dada por ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda](\[CapitalOmega](
            x\_0)) = \[Integral]\_c\%d\( f(x\_0, y)\) \[DifferentialD]y\)]],
  " (si tienes alguna duda, observa que la proyecci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega](x\_0)\)]],
  " sobre el plano ",
  StyleBox["YZ ",
    FontSlant->"Italic"],
  " es el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`{\((y, z)\) : y \[Element] \([c, d]\)\ , \ 
        0 \[LessEqual] z \[LessEqual] f(x\_0, y)}\)]],
  ").  Ahora hay que integrar las \[AAcute]reas de las secciones ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega](x)\)]],
  " cuando ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] \([a, b]\)\)]],
  " y obtenemos finalmente que"
}], "Text"],

Cell[TextData[{
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\(\[Integral]\_A\( f(x, y)\) \(d(x, 
                y)\)\) = \(volumen\ \((\[CapitalOmega])\) = \
\(\[Integral]\_a\%b\( \[Lambda](\[CapitalOmega](
                    x))\) \[DifferentialD]x = \[Integral]\_a\%b\([\[Integral]\
\_c\%d\( f(x, y)\) \[DifferentialD]y]\) \[DifferentialD]x\)\)\)],
    FontWeight->"Bold"]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Razonando de forma an\[AAcute]loga, considerando secciones ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega](y)\)]],
  " de ",
  StyleBox["\[CapitalOmega]",
    FontWeight->"Bold"],
  " paralelas al plano ",
  StyleBox["XZ",
    FontSlant->"Italic"],
  ", se obtiene la igualdad "
}], "Text"],

Cell[TextData[{
  " ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Integral]\(\[Integral]\_A\( f(x, y)\) \(d(x, 
                    y)\)\) = \(volumen\ \((\[CapitalOmega])\) = \(\[Integral]\
\_c\%d\( \[Lambda](\[CapitalOmega](
                        y))\) \[DifferentialD]y = \[Integral]\_c\%d\([\
\[Integral]\_a\%b\( f(x, y)\) \[DifferentialD]x]\) \[DifferentialD]y\)\)\),
          FontWeight->"Bold"], TraditionalForm]]]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Las integrales ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Integral]\_a\%b\([\[Integral]\_c\%d\( f(x, 
                      y)\) \[DifferentialD]y]\) \[DifferentialD]x\),
          FontWeight->"Bold"], TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Integral]\_c\%d\([\[Integral]\_a\%b\( f(x, 
                      y)\) \[DifferentialD]x]\) \[DifferentialD]y\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se llaman ",
  StyleBox["integrales iteradas ",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  "y, como consecuencia del teorema de Fubini, son iguales y su valor com\
\[UAcute]n es igual a la integral ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\(\[Integral]\_A\( f(x, y)\) \(d(x, 
              y)\)\)\)]],
  ". Observa que las integrales iteradas son dos integrales simples. Para \
calcular ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_c\%d\( f(x, y)\) \[DifferentialD]y\)]],
  " lo que se hace es integrar respecto a la variable ",
  StyleBox["y",
    FontSlant->"Italic"],
  " considerando",
  StyleBox[" x",
    FontSlant->"Italic"],
  " fija. Para ello lo que se hace es obtener una primitiva de la funci\
\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y\[LongRightArrow]\(f(x, y)\)\)]],
  " y usar la regla de Barrow. F\[IAcute]jate que una primitiva de la funci\
\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y\[LongRightArrow]\(f(x, y)\)\)]],
  " puede describirse como una ",
  StyleBox["primitiva parcial",
    FontSlant->"Italic"],
  " de ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(f(x, y)\)\(\ \)\)\)]],
  "con respecto a ",
  StyleBox["y. ",
    FontSlant->"Italic"],
  "\[DownQuestion]Te recuerda esto a la derivaci\[OAcute]n parcial?\nLa \
representaci\[OAcute]n gr\[AAcute]fica siguiente puede ayudarte a entender lo \
que se hace. La funci\[OAcute]n representada es ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \@\(36 - 3  x\^2 - 6  y\^2\)\)]],
  " en el rect\[AAcute]ngulo",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \ \)\(\([\(-2\), 2]\)\[Times]\([\(-2\), 
          2]\)\)\)\)]],
  ". Puedes ver el \"cilindro\" bajo la gr\[AAcute]fica de la \
funci\[OAcute]n, la secci\[OAcute]n del mismo por el plano ",
  StyleBox["X=0",
    FontSlant->"Italic"],
  " y la proyecci\[OAcute]n de dicha secci\[OAcute]n sobre el plano ",
  StyleBox["XZ.",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(fig1; \)\)], "Input"],

Cell[TextData[{
  "Para calcular una integral ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ 
      \[Integral]\(\[Integral]\_A\( f(x, y)\) \(d(x, y)\)\)\)\)]],
  " cuando el recinto de integraci\[OAcute]n ",
  StyleBox["A",
    FontSlant->"Italic"],
  " no es rect\[AAcute]ngulo se procede de la misma forma. La \[UAcute]nica \
diferencia es que ahora tenemos que empezar por determinar los valores de ",
  StyleBox["x",
    FontSlant->"Italic"],
  " tales que el plano ",
  StyleBox["X=x",
    FontSlant->"Italic"],
  " corta al \"cilindro\" bajo la gr\[AAcute]fica de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " , es decir, ",
  StyleBox[
  "tenemos que determinar la proyecci\[OAcute]n de A sobre el eje OX . ",
    FontSlant->"Italic"],
  "Supongamos que dicha proyecci\[OAcute]n sea un intervalo",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \([a, b]\)\)\)]],
  ". Ahora, para cada ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] \([a, b]\)\)]],
  " hay que calcular el \[AAcute]rea de la secci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega](x)\)]],
  ", o lo que es igual, el \[AAcute]rea de la regi\[OAcute]n en el plano",
  StyleBox[" YZ",
    FontSlant->"Italic"],
  " comprendida entre el eje ",
  StyleBox["OY",
    FontSlant->"Italic"],
  " y la curva ",
  Cell[BoxData[
      \(TraditionalForm\`z = f(x, y)\)]],
  " donde la variable ",
  StyleBox["y",
    FontSlant->"Italic"],
  " est\[AAcute] en el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A(x) = {y : \((x, y)\) \[Element] A}\)]],
  ". Supongamos que ",
  Cell[BoxData[
      FormBox[
        FormBox[\(A(x)\),
          "TraditionalForm"], TraditionalForm]]],
  " sea un intervalo (tampoco pasa nada si es uni\[OAcute]n de varios \
intervalos). Entonces tenemos que"
}], "Text"],

Cell[TextData[{
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\(\[Integral]\_A\( f(x, y)\) \(d(x, y)\)\) = 
        \[Integral]\_a\%b
            \([\[Integral]\_\(A(x)\)\(f(x, y)\) \[DifferentialD]y]\) 
            \[DifferentialD]x\)],
    FontWeight->"Bold"],
  StyleBox[". ",
    FontWeight->"Bold"]
}], "Text",
  TextAlignment->Center],

Cell["An\[AAcute]logamente se obtiene que", "Text"],

Cell[TextData[{
  " ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          \(\[Integral]\(\[Integral]\_A\(f(x, y)\) \(d(x, y)\)\) = 
            \[Integral]\_c\%d
                \([\[Integral]\_\(A(y)\)\(f(x, y)\) \[DifferentialD]x]\) 
                \[DifferentialD]y\),
          FontWeight->"Bold"], TraditionalForm]]],
  " "
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  Cell[BoxData[
      \(TraditionalForm\`\([c, d]\)\)]],
  " es la ",
  StyleBox["proyecci\[OAcute]n de ",
    FontSlant->"Italic"],
  StyleBox["A",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" sobre el eje OY",
    FontSlant->"Italic"],
  ", y para cada",
  Cell[BoxData[
      \(TraditionalForm\`\(\ y \[Element] \([c, d]\)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`A(y) = {x : \((x, y)\) \[Element] A}\)]],
  "."
}], "Text"],

Cell[TextData[{
  "En los casos m\[AAcute]s corrientes el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " suele ser un conjunto de tipo I o de tipo II (recuerda que los estudiamos \
en el cuaderno de ",
  StyleBox["Aplicaciones de la Integral",
    FontSlant->"Italic"],
  "). Esto es ",
  Cell[BoxData[
      \(TraditionalForm\`A = {\((x, y)\) : a \[LessEqual] x \[LessEqual] b, \ 
          g(x) \[LessEqual] y \[LessEqual] h(x)}\)]],
  " (tipo I) o bien ",
  Cell[BoxData[
      \(TraditionalForm\`A = {\((x, y)\) : 
            c \[LessEqual] y \[LessEqual] d, \ \[Phi](y) \[LessEqual] 
            x \[LessEqual] \[Sigma](y)}\)]],
  " (tipo II). En tales casos tenemos que "
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\(\[Integral]\_A\( f(x, y)\) \(d(x, 
                y)\)\) = \(\[Integral]\_a\%b\([\[Integral]\_\(A(x)\)\(f(x, 
                      y)\) \[DifferentialD]y]\) \[DifferentialD]x = \
\[Integral]\_a\%b\([\[Integral]\_\(g(x)\)\%\(h(x)\)\(f(x, 
                      y)\) \[DifferentialD]y]\) \[DifferentialD]x\)\)],
    FontWeight->"Bold"],
  "   (",
  StyleBox["A",
    FontSlant->"Italic"],
  " de tipo I)"
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Integral]\(\[Integral]\_A\( f(x, y)\) \(d(x, 
                    y)\)\) = \(\[Integral]\_c\%d\([\[Integral]\_\(A(y)\)\(f(
                          x, y)\) \[DifferentialD]x]\) \[DifferentialD]y = \
\[Integral]\_c\%d\([\[Integral]\_\(\[Phi](y)\)\%\(\[Sigma](y)\)\(f(x, 
                          y)\) \[DifferentialD]x]\) \[DifferentialD]y\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  "  (",
  StyleBox["A",
    FontSlant->"Italic"],
  " de tipo II)"
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "De forma an\[AAcute]loga a lo antes visto, el teorema de Fubini permite \
calcular integrales triples sin m\[AAcute]s que calcular tres integrales \
simples. Para el caso de una funci\[OAcute]n ",
  StyleBox[" f ",
    FontSlant->"Italic"],
  " definida en el rect\[AAcute]ngulo de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm
      \`A = \([a, b]\)\[Times]\([c, d]\)\[Times]\([u, v]\)\)]],
  " se tiene que "
}], "Text"],

Cell[TextData[{
  "\t\t\t",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\(\[Integral]\(\[Integral]\_A\( f(x, y, z)\) 
                \(d(x, y, z)\)\)\) = 
        \[Integral]\_a\%b
            \([\[Integral]\_c\%d
                  \([\[Integral]\_u\%v\( f(x, y, z)\) \[DifferentialD]z]\) 
                  \[DifferentialD]y]\) \[DifferentialD]x\)],
    FontWeight->"Bold"]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Observa que ahora hay seis integrales iteradas pero el valor de todas \
ellas es el mismo. Naturalmente, cuando ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " es un subconjunto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " hay m\[AAcute]s posibilidades, pero la idea es siempre la misma: ",
  StyleBox["se obtiene primero la proyecci\[OAcute]n de ",
    FontWeight->"Bold"],
  StyleBox["A",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[
  " sobre uno de los ejes o sobre uno de los planos coordenados, y para cada \
punto fijado en dicha proyecci\[OAcute]n se obtiene el conjunto de los puntos \
de ",
    FontWeight->"Bold"],
  StyleBox["A ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["que lo proyectan.",
    FontWeight->"Bold"],
  " \nSi, por ejemplo, la proyecci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " sobre el eje ",
  StyleBox["OZ",
    FontSlant->"Italic"],
  " es un intervalo",
  StyleBox[" ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`J = \([s, t]\)\)]],
  ", y para cada ",
  Cell[BoxData[
      \(TraditionalForm\`z \[Element] J\)]],
  " es ",
  Cell[BoxData[
      \(TraditionalForm
      \`A(z) = {\((x, y)\) : \((x, y, z)\) \[Element] A}\)]],
  ", entonces:\n\t\t\t",
  Cell[BoxData[
      FormBox[
        RowBox[{
          
          FormBox[\(\[Integral]\(\[Integral]\(\[Integral]\_A\( f(x, y, z)\) 
                    \[DifferentialD]\((x, y, z)\)\)\)\),
            "TraditionalForm"], "=", 
          \(\[Integral]\_s\%\(t\ 
              \)\([\[Integral]\(\[Integral]\_\(A(z)\)\(f(x, y, z)\) 
                      \[DifferentialD]\((x, y)\)\)]\) \[DifferentialD]z\)}], 
        TraditionalForm]],
    FontWeight->"Bold"],
  "\nEn el caso en que",
  StyleBox[" ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "sea un conjunto de tipo I en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ", es decir, ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "puede representarse en la forma ",
  Cell[BoxData[
      \(TraditionalForm
      \`A = {\((x, y, z)\) : \((x, y)\) \[Element] \[CapitalOmega], \ 
          g(x, y) \[LessEqual] z \[LessEqual] \ h(x, y)}\)]],
  ", donde ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalOmega]\)]],
  " es la proyecci\[OAcute]n de ",
  StyleBox["A",
    FontSlant->"Italic"],
  " sobre el plano ",
  StyleBox["XY",
    FontSlant->"Italic"],
  ", y  ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(g\ \), h\ \)\)]],
  " son funciones reales definidas en \[CapitalOmega], entonces:\n\t\t\t",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\(\[Integral]\(\[Integral]\_A\( f(x, y, z)\) 
                \[DifferentialD]\((x, y, z)\)\)\) = 
        \[Integral]\(\[Integral]\_\(\[CapitalOmega]\ 
              \)\([\[Integral]\_\(g(x, y)\)\%\(h(x, y)\)\(f(x, y, z)\) 
                    \[DifferentialD]z]\) \[DifferentialD]\((x, y)\)\)\)],
    FontWeight->"Bold"]
}], "Text"],

Cell["Los comandos Integrate[ ], NIntegrate[ ]", "Theorem"],

Cell[TextData[{
  "El comando \"Integrate[f[x,y],{x,a,b},{y,c,d}]\" calcula \
simb\[OAcute]licamente (cuando puede) la integral de f[x,y] cuando la \
variable ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] \([a, b]\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y \[Element] \([c, d]\)\)]],
  ". La integraci\[OAcute]n se realiza primero respecto de la variable ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  "."
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm
    \`Integrate[f[x, y], {x, a, b}, {y, c, d}] = 
      \[Integral]\_a\%b\([\[Integral]\_c\%d f[x, y] \[DifferentialD]y]\) 
          \[DifferentialD]x\)],
  FontWeight->"Bold"]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Los l\[IAcute]mites de integraci\[OAcute]n para la variable ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " pueden depender de la variable ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". El comando \"NIntegrate[f[x,y],{x,a,b},{y,c,d}]\" calcula \
num\[EAcute]ricamente la integral. Tambi\[EAcute]n puedes usar, con las \
modificaciones previsibles, estos comandos para funciones de tres variables. \
A partir de la versi\[OAcute]n 5 de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " estos comandos se han mejorado bastante y pueden integrar funciones del \
tipo \"If[cjto[x,y],f[x,y],0]\" para proporcionar directamente la integral de \
",
  Cell[BoxData[
      \(TraditionalForm\`f[x, y]\)]],
  " en el conjunto definido por \"cjto[x,y]\"."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejemplo 1", "Exercise"],

Cell[TextData[{
  "Calcular la integral de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \(x\ y\)\/\(1 + y\^2\)\)]],
  " en el conjunto ",
  Cell[BoxData[
      \(TraditionalForm
      \`A = {\((x, y)\) : x\^2 + y\^2 \[LessEqual] 1, \ x \[GreaterEqual] 0, 
          \ y \[GreaterEqual] 0}\)]],
  ". "
}], "Text"],

Cell[BoxData[
    \(Integrate[\(x*y\)\/\(1 + y\^2\), {x, 0, 1}, {y, 0, \@\(1 - x\^2\)}]\)], 
  "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ha calculado primero la integral"
}], "Text"],

Cell[BoxData[
    \(Integrate[\(x*y\)\/\(1 + y\^2\), {y, 0, \@\(1 - x\^2\)}]\)], "Input"],

Cell["y la funci\[OAcute]n obtenida la ha integrado en [0,1].", "Text"],

Cell[BoxData[
    \(Integrate[1\/2\ x\ Log[2 - x\^2], {x, 0, 1}]\)], "Input"],

Cell["\<\
Podr\[IAcute]amos haberlo hecho tambi\[EAcute]n invirtiendo el orden de \
integraci\[OAcute]n.\
\>", "Text"],

Cell[BoxData[
    \(Integrate[\(x*y\)\/\(1 + y\^2\), {y, 0, 1}, {x, 0, \@\(1 - y\^2\)}]\)], 
  "Input"],

Cell[BoxData[{
    \(Integrate[\(x*y\)\/\(1 + y\^2\), {x, 0, \@\(1 - y\^2\)}]\n\), 
    \(Integrate[%, {y, 0, 1}]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Calcula las integrales de las siguientes funciones en los conjuntos que se \
indican.\n",
  StyleBox["a)",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = x\ y\)]],
  " en el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " limitado por la recta ",
  Cell[BoxData[
      \(TraditionalForm\`y - x + 1 = 0\)]],
  " y la par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y\^2 - 2  x - 6 = 0\)]],
  ".\n",
  StyleBox["b) ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \ x\)]],
  " en el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`\(A\ \)\)]],
  "limitado por las curvas ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^4, \ y = 3  x - x\^2\)]],
  ".\n",
  StyleBox["c)",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \ x \@\( y\^2 - x\^2\)\)]],
  " en el tri\[AAcute]ngulo de v\[EAcute]rtices ",
  Cell[BoxData[
      \(TraditionalForm\`\((0, 0)\), \ \((0, 1)\), \((1, 1)\)\)]],
  ".\n",
  StyleBox["d) ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \ y\^2 - x\)]],
  " en el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " limitado por las curvas ",
  Cell[BoxData[
      \(TraditionalForm\`x - y\^2 = 0, \ \ x + 2  y\^2 - 3 = 0\)]],
  ".\n",
  StyleBox["e) ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \@\(4  x\^2 - y\^2\)\)]],
  " en el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " limitado por las rectas ",
  Cell[BoxData[
      \(TraditionalForm\`x = 1, \ y = 0, \ y = x\)]],
  ".\n",
  StyleBox["f) ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = 1\/\((1 + x + y + z)\)\^3\)]],
  " en el conjunto ",
  Cell[BoxData[
      \(TraditionalForm
      \`A = {\((x, y, z)\) \[Element] 
            \(\(\[DoubleStruckCapitalR]\^3\) : x \[GreaterEqual] 0\), \ 
          y \[GreaterEqual] 0, \ z \[GreaterEqual] 0, \ 
          x + y + z \[LessEqual] 1}\)]],
  ".\n",
  StyleBox["g)",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = z\)]],
  "  en el conjunto ",
  Cell[BoxData[
      \(TraditionalForm
      \`A = {\((x, y, z)\) \[Element] 
            \(\(\[DoubleStruckCapitalR]\^3\) : \ z \[GreaterEqual] 0\), \ 
          x\^2 + y\^2\/4 + z\^2\/9 \[LessEqual] 1}\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "Calcula los vol\[UAcute]menes de los cilindros en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " cuya base es el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " y cuya tapadera es la gr\[AAcute]fica de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " que se indican en cada caso. Representa gr\[AAcute]ficamente dichos \
cilindros.\n",
  StyleBox["a)",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \(x\ \)\^2 + y\^2\)]],
  ";  ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " es el conjunto limitado por las par\[AAcute]bolas ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2, \ \ x = y\^2\)]],
  ".\n",
  StyleBox["b) ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \ 3  x\^2 + y\^2\)]],
  ";  ",
  Cell[BoxData[
      \(TraditionalForm\`\(A\ \)\)]],
  "es el conjunto limitado por las curvas ",
  Cell[BoxData[
      \(TraditionalForm\`y = x, \ y\^2 - y - x = 0\)]],
  ".\n",
  StyleBox["c)",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \@\(4 - \ y\^2\)\)]],
  "; ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " es el tri\[AAcute]ngulo de v\[EAcute]rtices ",
  Cell[BoxData[
      \(TraditionalForm\`\((0, 0)\), \ \((0, 2)\), \((4, 2)\)\)]],
  ".\n",
  StyleBox["d) ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \ 2  x + 1\)]],
  ";  ",
  Cell[BoxData[
      \(TraditionalForm
      \`A = {\((x, y)\) \[Element] 
            \(\(\[DoubleStruckCapitalR]\^2\) : \ 
              x \[GreaterEqual] \(-1\)/2\), 
          x\^2 + \((y - 1)\)\^2 \[LessEqual] 1}\)]],
  ".\n",
  StyleBox["e)",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = y\)]],
  ";   ",
  Cell[BoxData[
      \(TraditionalForm\`\(A\ \)\)]],
  "es el conjunto limitado por las curvas ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = 1, \ y\^2 = 2\ x\)]],
  ". \n",
  StyleBox["f) ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = x\/\@\(1 + x\^2 + y\^2\)\)]],
  "; ",
  Cell[BoxData[
      \(TraditionalForm
      \`A = {\((x, y)\) \[Element] 
            \(\(\[DoubleStruckCapitalR]\^2\) : 
              0 \[LessEqual] \ x \[LessEqual] 2\), y\^2 \[LessEqual] 2  x}
          \)]],
  "."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Teorema del cambio de variables", "Section"],

Cell[TextData[{
  "Para funciones de una variable sabemos que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\_a\%b\( f(x)\) \[DifferentialD]x = 
        \[Integral]\_c\%d\( f(g(t))\) g' \((t)\) \[DifferentialD]t\)]],
  " donde se supone que ",
  Cell[BoxData[
      \(TraditionalForm\`a = g(c)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`b = g(d)\)]],
  ". Supongamos que la funci\[OAcute]n ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es inyectiva, entonces ",
  StyleBox["g",
    FontSlant->"Italic"],
  " debe ser creciente o decreciente. Si es decreciente se tiene que ",
  Cell[BoxData[
      \(TraditionalForm\`d < c\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`g' \((x)\) \[LessEqual] 0\)]],
  ", por lo que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\_c\%d\( f(g(t))\) g' \((t)\) \[DifferentialD]t = 
        \(\(-\(\[Integral]\_d\%c\( f(g(t))\) g' \((t)\) 
                \[DifferentialD]t\)\) = 
          \[Integral]\_d\%c f(g(t)) | g' \((t)\) | \[DifferentialD]t\)\)]],
  ". Podemos, por tanto, cuando ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es inyectiva, escribir en todos los casos"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\_a\%b\( f(x)\) \[DifferentialD]x = 
        \[Integral]\_\[Alpha]\%\[Beta] f(g(t)) | g' \((t)\) | 
          \[DifferentialD]t\)]],
  " "
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es una biyecci\[OAcute]n del intervalo",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \([\[Alpha], \[Beta]]\)\)\)]],
  " sobre ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)]],
  ". Esta f\[OAcute]rmula se generaliza para funciones de varias variables \
dando lugar al teorema del cambio de variables."
}], "Text"],

Cell["\<\
El teorema del cambio de variable para integrales dobles afirma que\
\>", "Text"],

Cell[TextData[{
  "\t\t\t",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\(\[Integral]\_A\( f(x, y)\) \(d(x, y)\)\) = 
        \[Integral]\(\[Integral]\_B\ f(g(u, v))\) | det\ \(\(J\_g\)(u, v)\) | 
          d(u, v)\)],
    FontWeight->"Bold"],
  " "
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde se supone que la funci\[OAcute]n ",
  StyleBox["g es una biyecci\[OAcute]n de B sobre A de clase ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`C\^1\)]],
  "(sus funciones componentes tienen derivadas parciales continuas) ",
  StyleBox["con determinante jacobiano distinto de cero, esto es, ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`det\ \(\(J\_g\)(u, v)\) \[NotEqual] \ 0\)]],
  " ",
  StyleBox["para todo",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\((u, v)\) \[Element] B\)]],
  ". En esta f\[OAcute]rmula se interpreta que la funci\[OAcute]n ",
  StyleBox["g",
    FontSlant->"Italic"],
  " hace un cambio de coordenadas pues permite asignar a cada punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\) \[Element] A\)]],
  " el \[UAcute]nico punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((u, v)\) \[Element] B\)]],
  " tal que ",
  Cell[BoxData[
      \(TraditionalForm\`g(u, v) = \((x, y)\)\)]],
  ". \n",
  StyleBox["Coordenadas polares",
    FontWeight->"Bold"],
  ". La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`g(\[Rho], \[Theta]) = 
        \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\)]],
  "es una biyecci\[OAcute]n de",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            FormBox[\(\[CapitalOmega] = \),
              "TraditionalForm"], 
            FormBox[\(\(\[DoubleStruckCapitalR]\^+\)\[Times]\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  "]",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\), \[Pi]\)]],
  "[ sobre ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalR]\^2\\{\((x, 0)\) : x \[LessEqual] 0}\)]],
  " (el plano al que se ha quitado el semieje de abscisas negativo). Las \
componentes de ",
  StyleBox["g",
    FontSlant->"Italic"],
  " tienen derivadas parciales continuas y f\[AAcute]cilmente se comprueba \
que ",
  Cell[BoxData[
      \(TraditionalForm
      \`det\ \(\(J\_g\)(\[Rho], \[Theta])\) = \[Rho] > 0\)]],
  ". Los n\[UAcute]meros \[Rho] y \[Theta] dados por ",
  Cell[BoxData[
      \(TraditionalForm\`x = \[Rho]\ cos\ \[Theta], \ 
      y = \[Rho]\ sen\ \[Theta]\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho] > 0\)]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(-\[Pi]\),
            "TraditionalForm"], "<", "\[Theta]", "\[LessEqual]", "\[Pi]"}], 
        TraditionalForm]]],
  " se llaman las coordenadas polares del punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  ". "
}], "Text"],

Cell[BoxData[
    \(\(polares; \)\)], "Input"],

Cell[TextData[{
  "Como aplicaci\[OAcute]n del teorema del cambio de variables obtenemos la \
igualdad\n\t\t",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\(\[Integral]\_A\( f(x, y)\) \(d(x, 
                y)\)\) = \[Integral]\(\[Integral]\_B\ \(f(\[Rho]\ cos\ \
\[Theta], \ \[Rho]\ sen\ \[Theta])\) \[Rho]\ \(d(\[Rho], \[Theta])\)\)\)],
    FontWeight->"Bold"],
  " \ndonde",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"B", "=", 
            RowBox[{"{", 
              RowBox[{\((\[Rho], \[Theta])\), ":", 
                RowBox[{
                  
                  FormBox[\((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \
\[Theta])\),
                    "TraditionalForm"], "\[Element]", " ", "A"}]}], "}"}]}]}],
         TraditionalForm]]],
  ". Si, por ejemplo, el conjunto ",
  StyleBox["A",
    FontSlant->"Italic"],
  " es de tipo I,  ",
  Cell[BoxData[
      \(TraditionalForm\`A = {\((x, y)\) : a \[LessEqual] x \[LessEqual] b, \ 
          g(x) \[LessEqual] y \[LessEqual] h(x)}\)]],
  ", entonces ",
  Cell[BoxData[
      FormBox[
        RowBox[{"B", "=", 
          RowBox[{"{", 
            RowBox[{\((\[Rho], \[Theta])\), ":", 
              
              FormBox[\(a \[LessEqual] \[Rho]\ cos\ \[Theta] \[LessEqual] b, 
                g(\ \[Rho]\ \ cos\ \[Theta]) \[LessEqual] \ \[Rho]\ sen\ \
\[Theta] \[LessEqual] \ h(\[Rho]\ cos\ \[Theta])\),
                "TraditionalForm"]}], "}"}]}], TraditionalForm]]],
  ". Es importante describir bien el conjunto ",
  StyleBox["B",
    FontSlant->"Italic"],
  " porque para calcular la integral ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\(\[Integral]\_B\ \(f(\[Rho]\ cos\ \
\[Theta], \ \[Rho]\ sen\ \[Theta])\) \[Rho]\ \(d(\[Rho], \[Theta])\)\)\)]],
  " tienes que aplicar, naturalmente, el teorema de Fubini. Si, por ejemplo, \
el conjunto ",
  StyleBox["B",
    FontSlant->"Italic"],
  " es de tipo II, ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          
          FormBox[\(B = {\((\[Rho], \[Theta])\) : 
                  c \[LessEqual] \[Theta] \[LessEqual] d, \ 
                g(\[Theta]) \[LessEqual] \[Rho] \[LessEqual] h(\[Theta])}\),
            "TraditionalForm"]}], TraditionalForm]]],
  ", entonces\n\t\t",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\(\[Integral]\_A\( f(x, y)\) \(d(x, 
                y)\)\) = \(\[Integral]\(\[Integral]\_B\ \(f(\[Rho]\ cos\ \
\[Theta], \ \[Rho]\ sen\ \[Theta])\) \[Rho]\ \(d(\[Rho], \[Theta])\)\) = \
\[Integral]\_c\%d\([\[Integral]\_\(g(\[Theta])\)\%\(h(\[Theta])\)\(f(\[Rho]\ \
cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\) \[Rho]\ \[DifferentialD]\[Rho]]\) \
\[DifferentialD]\[Theta]\)\)],
    FontWeight->"Bold"],
  "\nLas coordenadas polares son especialmente \[UAcute]tiles cuando el \
conjunto ",
  StyleBox["A",
    FontSlant->"Italic"],
  " es un c\[IAcute]rculo, o un sector circular o una corona circular, pues \
en estos casos el conjunto ",
  StyleBox["B",
    FontSlant->"Italic"],
  " es muy sencillo. Si, por ejemplo, ",
  StyleBox["A",
    FontSlant->"Italic"],
  " es el disco de centro el origen y radio ",
  StyleBox["R",
    FontSlant->"Italic"],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`A\  = \(D(0, 
            R) = {\((x, y)\) : 
              x\^2 + y\^2 \[LessEqual] R\^\(\(\ \)\(2\)\)}\)\)]],
  " entonces ",
  Cell[BoxData[
      \(TraditionalForm\`B = \({\((\[Rho], \[Theta])\) : \[Rho] \[LessEqual] \
\(R\^\ \)} = \([0, R]\)\[Times]\([\(-\[Pi]\), \[Pi]]\)\)\)]],
  ". Por tanto\n\t",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\(\[Integral]\_\(D(0, R)\)\(f(x, y)\) \(d(
                x, y)\)\) = \(\[Integral]\_\(\(-\[Pi]\)\(\ \)\)\%\[Pi]\([\
\[Integral]\_0\%R\( 
                      f(\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\) \
\[Rho]\ \[DifferentialD]\[Rho]]\) \[DifferentialD]\[Theta] = \
\[Integral]\_0\%R\ \([\[Integral]\_\(-\[Pi]\)\%\[Pi]\( 
                      f(\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\) \
\[Rho]\ \[DifferentialD]\[Theta]]\) \[DifferentialD]\[Rho]\)\)],
    FontWeight->"Bold"]
}], "Text"],

Cell[TextData[{
  "El teorema del cambio de variable para integrales triples afirma que\n\t\t\
\t",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\(\[Integral]\_A\( f(x, y, z)\) \(d(x, y, 
                z)\)\) = \[Integral]\(\[Integral]\_B\ f(g(u, v, w))\) | 
          det\ \(\(J\_g\)(u, v, w)\) | d(u, v, w)\)],
    FontWeight->"Bold"],
  " \ndonde se supone que la funci\[OAcute]n ",
  StyleBox["g es una biyecci\[OAcute]n de B sobre A de clase ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`C\^1\)]],
  "(sus funciones componentes tienen derivadas parciales continuas) ",
  StyleBox["con determinante jacobiano distinto de cero, esto es, ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`det\ \(\(J\_g\)(u, v, w)\) \[NotEqual] \ 0\)]],
  " ",
  StyleBox["para todo",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\((u, v, w)\) \[Element] B\)]],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["Coordenadas esf\[EAcute]ricas",
    FontWeight->"Bold"],
  ". La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`g(\[Rho], \[Theta], \[Phi]) = \((\[Rho]\ sen\[Phi]\ \
cos\ \[Theta], \ \[Rho]\ sen\[Phi]\ sen\ \[Theta], \[Rho]\ cos\[Phi])\)\)]],
  " es una biyecci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[CapitalOmega]\)\(=\)\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[DoubleStruckCapitalR]\^+\)\(\[Times]\)\)\)]],
  "]",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\), \[Pi]\)]],
  "[\[Times]]",
  Cell[BoxData[
      \(TraditionalForm\`0, \[Pi]\)]],
  "[ sobre ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\\{\((x, 0, z)\) : 
            x \[LessEqual] 0}\)]],
  ". Las componentes de ",
  StyleBox["g",
    FontSlant->"Italic"],
  " tienen derivadas parciales continuas y f\[AAcute]cilmente se comprueba \
que ",
  Cell[BoxData[
      \(TraditionalForm\`det\ \(\(J\_g\)(\[Rho], \[Theta], \[Phi])\) = \(-\
\[Rho]\^2\) sen\[Phi]\)]],
  ". Los n\[UAcute]meros \[Rho] y \[Theta] y \[Phi] dados por ",
  Cell[BoxData[
      \(TraditionalForm\`x = \[Rho]\ sen\[Phi]\ cos\ \[Theta], \ 
      y = \[Rho]\ sen\[Phi]sen\ \[Theta], \ z = \[Rho]\ cos\[Phi]\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho] > 0\)]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(-\[Pi]\),
            "TraditionalForm"], "<", "\[Theta]", "\[LessEqual]", "\[Pi]"}], 
        TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] \ \[Phi] \[LessEqual] \[Pi]\)]],
  " se llaman las coordenadas esf\[EAcute]ricas del punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  ". "
}], "Text"],

Cell[BoxData[
    \(\(esfericas; \)\)], "Input"],

Cell[TextData[{
  "Como aplicaci\[OAcute]n del teorema del cambio de variables obtenemos la \
igualdad\n\t\t",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\(\[Integral]\(\[Integral]\_A\ 
              \(f(x, y, z)\) \(d(x, y, z)\)\)\) = 
        \[Integral]\(\[Integral]\(\[Integral]\_B\ 
              \(f(\[Rho]\ sen\[Phi]\ cos\ \[Theta], \ 
                  \[Rho]\ sen\[Phi]\ sen\ \[Theta], \[Rho]\ cos\[Phi])\) 
                \(\[Rho]\^2\) sen\[Phi]\ 
                \(d(\[Rho], \[Theta], \[Phi])\)\)\)\)],
    FontWeight->"Bold"],
  " \ndonde",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"B", "=", 
            RowBox[{"{", 
              RowBox[{\((\[Rho], \[Theta], \[Phi])\), ":", 
                RowBox[{
                  
                  FormBox[
                    \((\[Rho]\ sen\[Phi]\ cos\ \[Theta], \ 
                      \[Rho]\ sen\[Phi]\ sen\ \[Theta], \[Rho]\ cos\[Phi])\),
                    "TraditionalForm"], "\[Element]", " ", "A"}]}], 
              "}"}]}]}], TraditionalForm]]],
  ". Las coordenadas esf\[EAcute]ricas son especialmente \[UAcute]tiles \
cuando el conjunto ",
  StyleBox["A",
    FontSlant->"Italic"],
  " es una esfera, o un sector esf\[EAcute]rico o una corona \
esf\[EAcute]rica, pues en estos casos el conjunto ",
  StyleBox["B",
    FontSlant->"Italic"],
  " es muy sencillo. Si, por ejemplo, ",
  StyleBox["A",
    FontSlant->"Italic"],
  " es la esfera de centro el origen y radio ",
  StyleBox["R",
    FontSlant->"Italic"],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm
      \`A\  = \(B(0, R) = {
            \((x, y, z)\) : x\^2 + y\^2 + z\^2 \[LessEqual] R\^\(\ 2\)}
            \)\)]],
  " entonces ",
  Cell[BoxData[
      \(TraditionalForm
      \`B = \({\((\[Rho], \[Theta], \[Phi])\) : 
              \[Rho] \[LessEqual] R\^\(\  \)} = 
          \([0, R]\)\[Times]\([\(-\[Pi]\), \[Pi]]\)\[Times]\([0, \[Pi]]
              \)\)\)]],
  ". Por tanto\n\t",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\(\[Integral]\(\[Integral]\_\(B(0, R)\)\(f(x, y, z)\) 
                \(d(x, y, z)\)\)\) = 
        \[Integral]\_0\%R
            \([\[Integral]\_\(\(-\[Pi]\)\ 
                  \)\%\[Pi]\([
                    \[Integral]\_0
                        \%\[Pi]\( f(\[Rho]\ sen\[Phi]\ cos\ \[Theta], \ 
                          \[Rho]\ sen\[Phi]\ sen\ \[Theta], \[Rho]\ cos\[Phi])
                          \) \(\[Rho]\^2\) sen\ \[Phi] \[DifferentialD]\[Phi]]
                    \) \[DifferentialD]\[Theta]]\) \[DifferentialD]\[Rho]\)],
    FontWeight->"Bold"],
  "\ny la integral iterada puede hacerse en el orden que se quiera."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "Calcula las integrales de las siguientes funciones en los conjuntos que se \
indican.\n",
  StyleBox["a)",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\(f(x, y) = x\ \)\)]],
  " en el c\[IAcute]rculo de centro el origen y radio 4.\n",
  StyleBox["b) ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \ y\)]],
  " en la regi\[OAcute]n del primer cuadrante limitada por el c\[IAcute]rculo \
de centro el origen y radio 5 y las rectas ",
  Cell[BoxData[
      \(TraditionalForm\`y = 0, \ y = x\)]],
  ".\n",
  StyleBox["c)",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \ log(1 + x\^2 + y\^2)\)]],
  " en el conjunto ",
  Cell[BoxData[
      \(TraditionalForm
      \`A = {\((x, y)\) \[Element] 
            \(\(\[DoubleStruckCapitalR]\^2\) : 
              4 \[LessEqual] x\^2 + y\^2 \[LessEqual] 9\)}\)]],
  ".\n",
  StyleBox["d) ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = exp(\(x\^2 + y\^2\)\/\(2  x\))\)]],
  " en el c\[IAcute]rculo de centro (1,0) y radio 1.\n",
  StyleBox["e) ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = x\^2 + y\^2\)]],
  " en el conjunto ",
  Cell[BoxData[
      \(TraditionalForm
      \`A = {\((x, y)\) \[Element] 
            \(\(\[DoubleStruckCapitalR]\^2\) : \ 
              \((x\^2 + y\^2)\)\^2 \[LessEqual] 4 \((x\^2 - y\^2)\)\), \ 
          x \[GreaterEqual] 0}\)]],
  ".\n",
  StyleBox["f) ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = 1\/\((1 + x\^2 + y\^2)\)\^\(3/2\)\)]],
  " en el conjunto ",
  Cell[BoxData[
      \(TraditionalForm
      \`A = {\((x, y)\) \[Element] 
            \(\(\[DoubleStruckCapitalR]\^2\) : 
              0 \[LessEqual] x \[LessEqual] 1\), \ 
          0 \[LessEqual] y \[LessEqual] 1/\@3}\)]],
  ".\n",
  StyleBox["g) ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = z\)]],
  " en el conjunto ",
  Cell[BoxData[
      \(TraditionalForm
      \`A = {\((x, y, z)\) \[Element] 
            \(\(\[DoubleStruckCapitalR]\^3\) : 
              x\^2 + y\^2 + z\^2 \[LessEqual] R\^\(\ 2\)\), \ 
          z \[GreaterEqual] 0}\)]],
  "."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 703}},
AutoGeneratedPackage->None,
WindowSize->{995, 628},
WindowMargins->{{2, Automatic}, {Automatic, 2}},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Integraci\[OAcute]n de funciones de varias variables."], 
        "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Integraci\[OAcute]n de funciones de varias variables."], 
        "Header"]}},
Magnification->1.25,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 69, 0, 69, "Title"],
Cell[1781, 51, 204, 4, 72, "Author"],

Cell[CellGroupData[{
Cell[2010, 59, 39, 0, 69, "Section"],
Cell[2052, 61, 281, 6, 99, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2370, 72, 41, 0, 69, "Section"],
Cell[2414, 74, 80, 2, 60, "Input",
  InitializationCell->True],
Cell[2497, 78, 214, 4, 81, "Input",
  InitializationCell->True],
Cell[2714, 84, 2893, 58, 549, "Input",
  InitializationCell->True],
Cell[5610, 144, 4222, 80, 405, "Input",
  InitializationCell->True],
Cell[9835, 226, 918, 16, 186, "Input",
  InitializationCell->True],
Cell[10756, 244, 1628, 28, 291, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[12421, 277, 75, 0, 43, "Section"],
Cell[12499, 279, 1065, 31, 75, "Text"],
Cell[13567, 312, 311, 9, 33, "Text"],
Cell[13881, 323, 1664, 49, 96, "Text"],
Cell[15548, 374, 384, 10, 70, "Text"],
Cell[15935, 386, 626, 19, 55, "Text"],
Cell[16564, 407, 278, 6, 33, "Text"],
Cell[16845, 415, 315, 6, 123, "Input"],
Cell[17163, 423, 433, 11, 54, "Text"],
Cell[17599, 436, 180, 4, 35, "Text"],
Cell[17782, 442, 331, 5, 81, "Input"],
Cell[18116, 449, 496, 8, 75, "Text"],
Cell[18615, 459, 566, 11, 144, "Input"],
Cell[19184, 472, 1192, 26, 117, "Text"],
Cell[20379, 500, 340, 6, 102, "Input"],
Cell[20722, 508, 151, 3, 33, "Text"],
Cell[20876, 513, 521, 9, 144, "Input"],
Cell[21400, 524, 42, 0, 33, "Text"],
Cell[21445, 526, 96, 2, 81, "Input"],
Cell[21544, 530, 77, 0, 33, "Text"],
Cell[21624, 532, 1648, 46, 117, "Text"],
Cell[23275, 580, 755, 13, 201, "Input"],
Cell[24033, 595, 135, 3, 33, "Text"],
Cell[24171, 600, 205, 4, 33, "Text"],
Cell[24379, 606, 334, 6, 102, "Input"],
Cell[24716, 614, 42, 0, 33, "Text"],
Cell[24761, 616, 201, 5, 107, "Input"],
Cell[24965, 623, 778, 25, 56, "Text"],
Cell[25746, 650, 354, 9, 33, "Text"],
Cell[26103, 661, 1878, 52, 197, "Text"],

Cell[CellGroupData[{
Cell[28006, 717, 31, 0, 48, "Exercise"],
Cell[28040, 719, 718, 15, 96, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28795, 739, 31, 0, 48, "Exercise"],
Cell[28829, 741, 829, 13, 117, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[29707, 760, 36, 0, 69, "Section"],
Cell[29746, 762, 2435, 64, 196, "Text"],
Cell[32184, 828, 345, 9, 33, "Text"],
Cell[32532, 839, 1491, 46, 76, "Text"],
Cell[34026, 887, 462, 11, 34, "Text"],
Cell[34491, 900, 321, 11, 34, "Text"],
Cell[34815, 913, 470, 11, 33, "Text"],
Cell[35288, 926, 2452, 65, 194, "Text"],
Cell[37743, 993, 43, 1, 60, "Input"],
Cell[37789, 996, 1798, 53, 117, "Text"],
Cell[39590, 1051, 394, 13, 36, "Text"],
Cell[39987, 1066, 51, 0, 33, "Text"],
Cell[40041, 1068, 374, 12, 35, "Text"],
Cell[40418, 1082, 487, 19, 34, "Text"],
Cell[40908, 1103, 707, 18, 54, "Text"],
Cell[41618, 1123, 511, 13, 36, "Text"],
Cell[42132, 1138, 569, 14, 36, "Text"],
Cell[42704, 1154, 518, 14, 54, "Text"],
Cell[43225, 1170, 468, 14, 34, "Text"],
Cell[43696, 1186, 3144, 96, 233, "Text"],
Cell[46843, 1284, 59, 0, 60, "Theorem"],
Cell[46905, 1286, 449, 13, 54, "Text"],
Cell[47357, 1301, 262, 6, 32, "Text"],
Cell[47622, 1309, 799, 19, 96, "Text"],

Cell[CellGroupData[{
Cell[48446, 1332, 29, 0, 48, "Exercise"],
Cell[48478, 1334, 340, 10, 38, "Text"],
Cell[48821, 1346, 103, 2, 74, "Input"],
Cell[48927, 1350, 117, 4, 33, "Text"],
Cell[49047, 1356, 89, 1, 74, "Input"],
Cell[49139, 1359, 71, 0, 33, "Text"],
Cell[49213, 1361, 77, 1, 73, "Input"],
Cell[49293, 1364, 118, 3, 33, "Text"],
Cell[49414, 1369, 103, 2, 74, "Input"],
Cell[49520, 1373, 127, 2, 118, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49684, 1380, 31, 0, 48, "Exercise"],
Cell[49718, 1382, 2426, 84, 251, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[52181, 1471, 31, 0, 48, "Exercise"],
Cell[52215, 1473, 2397, 83, 245, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[54661, 1562, 50, 0, 69, "Section"],
Cell[54714, 1564, 1178, 35, 77, "Text"],
Cell[55895, 1601, 250, 8, 34, "Text"],
Cell[56148, 1611, 398, 12, 54, "Text"],
Cell[56549, 1625, 91, 2, 33, "Text"],
Cell[56643, 1629, 301, 10, 33, "Text"],
Cell[56947, 1641, 2631, 80, 151, "Text"],
Cell[59581, 1723, 46, 1, 60, "Input"],
Cell[59630, 1726, 4070, 102, 306, "Text"],
Cell[63703, 1830, 945, 25, 120, "Text"],
Cell[64651, 1857, 1752, 51, 76, "Text"],
Cell[66406, 1910, 48, 1, 60, "Input"],
Cell[66457, 1913, 2671, 69, 209, "Text"],

Cell[CellGroupData[{
Cell[69153, 1986, 31, 0, 48, "Exercise"],
Cell[69187, 1988, 2263, 71, 255, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

